<?php
add_action('template_redirect', function() {
  if(isset($_POST['wpsaas_update_company'])){
    wp_update_post( array( 'ID' => esc_attr( wpsaas_get_company_id() ), 'post_title' => esc_attr( $_POST['company_name'] ) ) );
    wpsaas_company_form_fields_process( wpsaas_get_company_id() );
    wp_redirect('?update' );
  }
  if(isset($_POST['wpsaas_create_company'])){
    $company_id = wpsaas_create_post('wpsaas_company', 'publish', get_current_user_id(), $_POST['company_name'] );
    wpsaas_company_form_fields_process( $company_id );
    wp_redirect( '?success' );
  }

});
function wpsaas_company_content(){

 $company_id = wpsaas_get_company_id();
 $wpsaas_dashboard_page_url = get_permalink( get_option( 'wpsaas_dashboard_page_id' ) );
?>


              <a href='<?php echo $wpsaas_dashboard_page_url; ?>' alt='<?php _e('Return to Dashboard', 'wpsaas'); ?>' title='<?php _e('Return to Dashboard', 'wpsaas'); ?>' style='padding: 0;text-align: left;' class="return-link">
                  <?php _e('&larr; Return to Dashboard', 'wpsaas'); ?>
              </a>

              <?php
                if( isset( $_GET['success'] ) )
                  echo "<p class='alert-success'>Company created successfully.</p>";

                if( isset( $_GET['update'] ) )
                  echo "<p class='alert-update'>Company information updated successfully.";

              ?>

              <!-- Form for company start -->
              <div class='wpsaas-form'>
  							<form id="post" class="post-edit front-end-form" method="post" enctype="multipart/form-data">

  							    <?php
                      wpsaas_display_company_form_fields($company_id);
                      if($company_id){
                          echo '<input type="submit" id="submit" value="Update" name = "wpsaas_update_company" />';
                      } else {
                          echo '<input type="submit" id="submit" value="Create  " name = "wpsaas_create_company" />';
                      }
                      ?>

  							</form>
              </div>
              <!-- Form for company end -->
<?php } add_shortcode( 'wpsaas-company', 'wpsaas_company_content' );