<?php
/*
 * Check for S2membership plugin before activating this plugin
 *
*/
function wpsaas_check_require_plugin(){

  // Require parent plugin
  if ( ! is_plugin_active( 's2member/s2member.php' ) and current_user_can( 'activate_plugins' ) ) {
      // Stop activation redirect and show error
      wp_die('Sorry, but this plugin requires S2Membership plguin to be installed and active. <br><a href="' . admin_url( 'plugins.php' ) . '">&laquo; Return to Plugins</a>');
  }
}

/*
 * Add image support to wordpress form
 *
*/
function wpsaas_add_edit_form_multipart_encoding() {

    echo ' enctype="multipart/form-data"';

}
add_action('post_edit_form_tag', 'wpsaas_add_edit_form_multipart_encoding');

/*
 * Add CSS to wordpress admin area
 *
*/
function wpsaas_load_admin_styles() {
  wp_enqueue_style( 'wpsaas_admin_css', plugins_url('css/wpsaas-admin-css.css',__FILE__ ), false, '' );
}
add_action( 'admin_enqueue_scripts', 'wpsaas_load_admin_styles' );

/*
 * Add CSS & js to front-end
 *
*/
function wpsaas_load_front_end_css()
{
    wp_enqueue_script( 'wpsaas-datatables-js', plugins_url( '/js/datatables-min.js' , __FILE__ ), array( 'jquery' ) );
    wp_enqueue_script( 'wpsaas-script', plugins_url( '/js/wpsaas-script.js' , __FILE__ ), array( 'jquery' ) );


    wp_register_style( 'wpsaas-style', plugins_url( '/css/wpsaas-style.css', __FILE__ ), false, '');
    wp_enqueue_style( 'wpsaas-style' );

    wp_register_style( 'wpsaas-datatables', '//cdn.datatables.net/1.10.11/css/jquery.dataTables.min.css', false, '');
    wp_enqueue_style( 'wpsaas-datatables' );

    wp_register_style( 'wpsaas-fontawesome', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css', false, '');
    wp_enqueue_style( 'wpsaas-fontawesome' );


}
add_action( 'wp_enqueue_scripts', 'wpsaas_load_front_end_css' );


/*
 * Add Meta boxes to custom post types
 *
*/
function wpsaas_metaboxes(){

  add_meta_box( 'wpsaas_company_metabox',
                'Company Information',
                'wpsaas_display_company_meta_box',
                'wpsaas_company', 'normal', 'high'
              );

  add_meta_box( 'wpsaas_company_contact_metabox',
                'Company Contact Information',
                'wpsaas_display_company_contact_meta_box',
                'wpsaas_company_contact', 'normal', 'high'
              );
}

/*
 * Get Current User Company ID
 *
*/
function wpsaas_get_company_id(){

  $member_company_args = array( 'author' => get_current_user_id(), 'post_type' => 'wpsaas_company');
  $member_company = new WP_Query($member_company_args);
  if(isset($member_company->post->ID) && !is_null($member_company->post->ID))
    return $member_company->post->ID;
  else
    return '';

}
/*
 * Create any post like company, company contact etc.
 *
*/

function wpsaas_create_post($post_type, $post_status, $user_id, $post_title){
  $post_information = array(
                            'post_type' 	  =>  $post_type,
                            'post_status'   =>  $post_status,
                            'post_author'   =>  $user_id,
                            'post_title'    =>  wp_strip_all_tags( $post_title )
                            );
  $new_post_id = wp_insert_post( $post_information );
  return $new_post_id;
}

/*
 * Get Current User/company contacts
 *
*/
function wpsaas_list_company_contacts($company_id){

  $args = array(
              'post_type'         => 'wpsaas_contact',
              'post_status'       => 'publish',
              'posts_per_page'    => -1,
              'orderby'           => 'ASC',
              'meta_query'        => array(
                  array(
                      'key'       => 'user_company',
                      'value'     => $company_id,
                      'compare'   => '='
                  )
              )
              );
  $contacts = get_posts($args);

  $output = '';

  if(!empty($contacts)){
    $contact_page_url = get_permalink(get_option( 'wpsaas_company_contacts_page_id' ));

    $output .= '<table id="company-contacts-list" class="display" cellspacing="0" width="100%">';
    $output .= '<thead>';
    $output .= '<tr>';
    $output .= '<th>Contact Name</th>';
    $output .= '<th>Actions</th>';
    $output .= '</tr>';
    $output .= '</thead>';
    $output .= '<tbody>';

  foreach ($contacts as $contact) {

        $output .= '<tr>';
        $output .= '<td>';
        $output .= "$contact->post_title";
        $output .= '</td>';
        $output .= '<td>';

        $contact_id = $contact->ID;


              $output .= '<a href="'.$contact_page_url.'?contact='.$contact_id.'&action=edit" title="Modify" class="edit  pull-left">  <i class="fa fa-pencil"></i></a>';

              $output .= '<form method="POST" class="wpsaas-form contact-delete" id="delete-contact">';
              $output .= '<input type="hidden" name="contact_id" value="'.$contact_id.'">';
              $output .= '<input type="hidden" name="wpsaas_delete_company_contact" value="Delete"> <a class="delete" href="#"><i class="fa fa-trash"></i></a>';
              $output .= '</form>';
              $output .= '</td>';
              $output .= '</tr>';

  }
    $output .= '</tbody>';
    $output .= '</table>';
 } else {
          $output .= __("No Contacts Found.", 'wpsaas');
      }

      return $output;
}