<?php
/**
 * Plugin Name: WP-SASS
 * Plugin URI: #
 * Description: Plugin Description Goes here..
 * Version: 1.0.1
 * Author: fl@ck
 * Author URI: #
 * Text Domain: wpssas
 * License: GPL2
 */

if ( !defined( 'ABSPATH' ) ) exit;

require_once( plugin_dir_path( __FILE__ ) . 'inc/wpssas-functions.php' );

function wpssas_setup() {
  // Register our "company" and "contact" custom post type
  require_once( plugin_dir_path( __FILE__ ) . 'inc/wpssas-register-post-type.php' );
}
add_action( 'init', 'wpssas_setup' );

function wpssas_shortcode() {
  require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/wpssas-shortcodes.php' );
  require_once( plugin_dir_path( __FILE__ ) . 'inc/wpssas-company-meta-box.php' );
  require_once( plugin_dir_path( __FILE__ ) . 'inc/wpssas-company-contact-meta-box.php' );
}
add_action( 'init', 'wpssas_shortcode' );


function wpssas_create_pages(){

    if('' == get_option( 'wpssas_dashboard_page_id' )){

      $dashboard_page = array(
        'post_title'    => 'WP-SAAS Dashboard',
        'post_content'  => '<p style="text-align:center;">*** Dashboard specimen for connected members ***</p>[wpssas-dashboard]',
        'post_status'   => 'publish',
        'post_author'   => get_current_user_id(),
        'post_type'     => 'page',
      );
      $wpssas_dashboard_page_id = wp_insert_post( $dashboard_page, '' );
      update_option('wpssas_dashboard_page_id', $wpssas_dashboard_page_id);

    }

    if('' == get_option( 'wpssas_company_page_id' )){

      $dashboard_page = array(
        'post_title'    => 'WP-SAAS Company details management',
        'post_content'  => '[wpssas-company]',
        'post_status'   => 'publish',
        'post_author'   => get_current_user_id(),
        'post_type'     => 'page',
      );
      $wpssas_company_page_id = wp_insert_post( $dashboard_page, '' );
      update_option('wpssas_company_page_id', $wpssas_company_page_id);

    }

    if('' == get_option( 'wpssas_company_contacts_page_id' )){

      $dashboard_page = array(
        'post_title'    => 'WP-SAAS Company contact management',
        'post_content'  => '[wpssas-contact]',
        'post_status'   => 'publish',
        'post_author'   => get_current_user_id(),
        'post_type'     => 'page',
      );
      $wpssas_company_contacts_page_id = wp_insert_post( $dashboard_page, '' );
      update_option('wpssas_company_contacts_page_id', $wpssas_company_contacts_page_id);

    }

}

add_action('admin_menu', 'wpssas_plugin_menu');

function wpssas_plugin_menu() {
  add_menu_page('wpssas', 'WP-SAAS', 'administrator', 'wpssas-settings', 'wpssas_settings_page', 'dashicons-admin-generic');
}

function wpssas_settings_page() {
?>
<div class="wrap">
<h2>WP-SAAS Settings</h2>

<form method="post" action="options.php">
    <?php settings_fields( 'wpssas-settings-group' ); ?>
    <?php do_settings_sections( 'wpssas-settings-group' ); ?>
    <table class="form-table">
        <tr valign="top">
        <th scope="row">Dashboard for connected members</th>
        <td>
          <select name="wpssas_dashboard_page_id">
            <option selected="selected" disabled="disabled" value=""><?php echo esc_attr( __( 'Select page' ) ); ?></option>
            <?php
                $selected_page = get_option( 'wpssas_dashboard_page_id' );
                $pages = get_pages();
                foreach ( $pages as $page ) {
                    $option = '<option value="' . $page->ID . '" ';
                    $option .= ( $page->ID == $selected_page ) ? 'selected="selected"' : '';
                    $option .= '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                }
            ?>
          </select>
        </td>
        </tr>

        <tr valign="top">
        <th scope="row">Company details management</th>
        <td>
          <select name="wpssas_company_page_id">
            <option selected="selected"  disabled="disabled" value=""><?php echo esc_attr( __( 'Select page' ) ); ?></option>
            <?php
                $selected_page = get_option( 'wpssas_company_page_id' );
                $pages = get_pages();
                foreach ( $pages as $page ) {
                    $option = '<option value="' . $page->ID . '" ';
                    $option .= ( $page->ID == $selected_page ) ? 'selected="selected"' : '';
                    $option .= '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                }
            ?>
          </select>
        </td>
        </tr>

        <tr valign="top">
        <th scope="row">Company contact management</th>
        <td>
          <select name="wpssas_company_contacts_page_id">
            <option selected="selected" disabled="disabled" value=""><?php echo esc_attr( __( 'Select page' ) ); ?></option>
            <?php
                $selected_page = get_option( 'wpssas_company_contacts_page_id' );
                $pages = get_pages();
                foreach ( $pages as $page ) {
                    $option = '<option value="' . $page->ID . '" ';
                    $option .= ( $page->ID == $selected_page ) ? 'selected="selected"' : '';
                    $option .= '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                }
            ?>
          </select>
        </td>
        </tr>
    </table>

    <?php submit_button(); ?>

</form>
</div>
<?php
}

add_action( 'admin_init', 'wpssas_plugin_settings' );
function wpssas_plugin_settings() {
	register_setting( 'wpssas-settings-group', 'wpssas_dashboard_page_id' );
	register_setting( 'wpssas-settings-group', 'wpssas_company_page_id' );
	register_setting( 'wpssas-settings-group', 'wpssas_company_contacts_page_id' );

  // add meta boxes for custom post types.
  wpssas_metaboxes();
}

function wpssas_activation() {

  // Check if require plugins are active.
  wpssas_check_require_plugin();

  // Trigger our function that registers the custom post type
  wpssas_setup();

  // Create require pages on activation
  wpssas_create_pages();

  // Clear the permalinks after the post type has been registered
  flush_rewrite_rules();

}
register_activation_hook( __FILE__, 'wpssas_activation' );

function wpssas_deactivation() {

  // Our post type will be automatically removed, so no need to unregister it

  // Clear the permalinks to remove our post type's rules
  flush_rewrite_rules();

}

register_deactivation_hook( __FILE__, 'wpssas_deactivation' );