<?php
add_action('template_redirect', function() {
if( isset($_GET['contact']) && $_GET['contact'] != '' ){
  $args = array(
              'post_type'         => 'wpssas_contact',
              'post_status'       => 'publish',
              'posts_per_page'    => -1,
              'orderby'           => 'ASC',
              'meta_query'        => array(
                  array(
                      'key'       => 'user_company',
                      'value'     => wpssas_get_company_id(),
                      'compare'   => '='
                  )
              )
              );
  $contacts = get_posts($args);

  $is_genuine = 'no';

  ## Security check if member try to access contact of any another company by changing contact id in url.
  foreach ($contacts as $contact) {
    if($_GET['contact'] == $contact->ID){
      $is_genuine = 'yes';
    }
  }

  if($is_genuine == 'no'){
    wp_redirect( get_permalink( get_option( 'wpssas_dashboard_page_id' ) )); // redirect to dashboard.
    exit;
  }
}

  if(isset($_POST['wpssas_update_company_contact'])){
    wp_update_post( array( 'ID' => esc_attr( $_POST['contact_id'] ), 'post_title' => esc_attr( $_POST['user_nom'].' '.$_POST['user_prenom'] ) ) );
    wpssas_company_contact_form_fields_process( esc_attr( $_POST['contact_id'] ) );
    wp_redirect( get_permalink( $_SERVER['PHP_SELF'] ).'?update' );
  }
  if(isset($_POST['wpssas_create_company_contact'])){
    $contact_id = wpssas_create_post('wpssas_contact', 'publish', get_current_user_id(), $_POST['user_nom'].' '.$_POST['user_prenom'] );
    wpssas_company_contact_form_fields_process( $contact_id );
    wp_redirect( get_permalink( $_SERVER['PHP_SELF'] ).'?success' );
  }
  if(isset($_POST['wpssas_delete_company_contact'])){
    wp_delete_post( esc_attr( $_POST['contact_id'] ) );
    wp_redirect( get_permalink( $_SERVER['PHP_SELF'] ).'?delete' );
  }

});
function wpssas_company_contact_content(){

 $company_id = wpssas_get_company_id();
 $wpssas_dashboard_page_url = get_permalink( get_option( 'wpssas_dashboard_page_id' ) );
 settype($contact_id, "integer");
 if( isset($_GET['contact']) && $_GET['contact'] != '' ){
   $contact_id = esc_attr( $_GET['contact'] );
 }
?>


              <a href='<?php echo $wpssas_dashboard_page_url; ?>' alt='<?php _e('Return to Dashboard', 'wpssas'); ?>' title='<?php _e('Return to Dashboard', 'wpssas'); ?>' style='padding: 0;text-align: left;' class="return-link">
                  <?php _e('&larr; Return to Dashboard', 'wpssas'); ?>
              </a>

              <?php
                if( isset( $_GET['success'] ) )
                  echo "<p class='alert-success'>Contact created successfully.</p>";

                if( isset( $_GET['update'] ) )
                  echo "<p class='alert-update'>Contact information updated successfully.";


              ?>

              <div class='add-contact-form wpssas-form'>
                  <!-- Form for company start -->

    							<form id="post" class="post-edit front-end-form" method="post" enctype="multipart/form-data">


                      <?php
                        wpssas_display_company_contact_form_fields($contact_id);
                        if( isset($_GET['contact']) && $_GET['contact'] != '' ){
                            echo '<input type="submit" id="submit" value="Update" name = "wpssas_update_company_contact" />';
                            echo '<a class="cancle-link" href="'.get_permalink( get_option( 'wpssas_company_contacts_page_id' ) ).'">Cancle</a>';
                        } else {
                            echo '<input type="submit" id="submit" value="Create" name = "wpssas_create_company_contact" />';
                        }
                        ?>

    							</form>

                  <!-- Form for company end -->
              </div>
<?php } add_shortcode( 'wpssas-contact', 'wpssas_company_contact_content' );