<?php
/**
 *  Add company custom post type
 */
function wpssas_company_post_type() {
  $labels = array(
                    'name'                  => __( 'Companies', 'Post Type General Name', 'konepa' ),
                    'singular_name'         => __( 'Company', 'Post Type Singular Name', 'konepa' ),
                    'menu_name'             => __( 'Company', 'konepa' ),
                    'name_admin_bar'        => __( 'Company', 'konepa' ),
                    'archives'              => __( 'Company Archives', 'konepa' ),
                    'parent_item_colon'     => __( 'Parent Company:', 'konepa' ),
                    'all_items'             => __( 'All Companies', 'konepa' ),
                    'add_new_item'          => __( 'Add New Company', 'konepa' ),
                    'add_new'               => __( 'Add New Company', 'konepa' ),
                    'new_item'              => __( 'New Company', 'konepa' ),
                    'edit_item'             => __( 'Edit Company', 'konepa' ),
                    'update_item'           => __( 'Update Company', 'konepa' ),
                    'view_item'             => __( 'View Company', 'konepa' ),
                    'search_items'          => __( 'Search Company', 'konepa' ),
                    'not_found'             => __( 'Not found', 'konepa' ),
                    'not_found_in_trash'    => __( 'Not found in Trash', 'konepa' ),
                    'featured_image'        => __( 'Featured Image', 'konepa' ),
                    'set_featured_image'    => __( 'Set featured image', 'konepa' ),
                    'remove_featured_image' => __( 'Remove featured image', 'konepa' ),
                    'use_featured_image'    => __( 'Use as featured image', 'konepa' ),
                    'insert_into_item'      => __( 'Insert into Company', 'konepa' ),
                    'uploaded_to_this_item' => __( 'Uploaded to this Company', 'konepa' ),
                    'items_list'            => __( 'Companies list', 'konepa' ),
                    'items_list_navigation' => __( 'Companies list navigation', 'konepa' ),
                    'filter_items_list'     => __( 'Filter Companies list', 'konepa' ),
                  );
  $args = array(
                'label'                 => __( 'Company', 'konepa' ),
                'description'           => __( 'Post Type Description', 'konepa' ),
                'labels'                => $labels,
                'supports'              => array( 'title', 'author', 'revisions', ),
                'hierarchical'          => false,
                'public'                => true,
                'show_ui'               => true,
                'show_in_menu'          => true,
                'menu_position'         => 5,
                'show_in_nav_menus'     => true,
                'can_export'            => true,
                'has_archive'           => true,
                'publicly_queryable'    => true,
                'capability_type'       => 'post',
                );
  register_post_type( 'wpssas_company', $args );
}
/**
 *  Add company contact custom post type
 */
function wpssas_company_contact_post_type() {

$labels = array(
                	'name'                  => _x( 'Contacts', 'Post Type General Name', 'konepa' ),
                	'singular_name'         => _x( 'Contact', 'Post Type Singular Name', 'konepa' ),
                	'menu_name'             => __( 'Company Contact', 'konepa' ),
                	'name_admin_bar'        => __( 'Company Contact', 'konepa' ),
                	'archives'              => __( 'Contact Archives', 'konepa' ),
                	'parent_item_colon'     => __( 'Parent Item:', 'konepa' ),
                	'all_items'             => __( 'All Contacts', 'konepa' ),
                	'add_new_item'          => __( 'Add New Contact', 'konepa' ),
                	'add_new'               => __( 'Add New Contact', 'konepa' ),
                	'new_item'              => __( 'New Contact', 'konepa' ),
                	'edit_item'             => __( 'Edit Contact', 'konepa' ),
                	'update_item'           => __( 'Update Contact', 'konepa' ),
                	'view_item'             => __( 'View Contact', 'konepa' ),
                	'search_items'          => __( 'Search Contact', 'konepa' ),
                	'not_found'             => __( 'Not found', 'konepa' ),
                	'not_found_in_trash'    => __( 'Not found in Trash', 'konepa' ),
                	'featured_image'        => __( 'Featured Image', 'konepa' ),
                	'set_featured_image'    => __( 'Set featured image', 'konepa' ),
                	'remove_featured_image' => __( 'Remove featured image', 'konepa' ),
                	'use_featured_image'    => __( 'Use as featured image', 'konepa' ),
                	'insert_into_item'      => __( 'Insert into Contact', 'konepa' ),
                	'uploaded_to_this_item' => __( 'Uploaded to this Contact', 'konepa' ),
                	'items_list'            => __( 'Contacts list', 'konepa' ),
                	'items_list_navigation' => __( 'Contacts list navigation', 'konepa' ),
                	'filter_items_list'     => __( 'Filter items list', 'konepa' ),
                );
$args = array(
              	'label'                 => __( 'Contact', 'konepa' ),
              	'description'           => __( 'Post Type Description', 'konepa' ),
              	'labels'                => $labels,
              	'supports'              => array( 'title', 'author', 'revisions', ),
              	'hierarchical'          => false,
              	'public'                => true,
              	'show_ui'               => true,
              	'show_in_menu'          => true,
              	'menu_position'         => 6,
              	'show_in_admin_bar'     => true,
              	'show_in_nav_menus'     => true,
              	'can_export'            => true,
              	'has_archive'           => true,
              	'exclude_from_search'   => false,
              	'publicly_queryable'    => true,
              	'capability_type'       => 'post',
              );
register_post_type( 'wpssas_contact', $args );
}
/**
 *  Call function to execute its code.
 */
wpssas_company_post_type();
wpssas_company_contact_post_type();