<?php
/*
 * Check for S2membership plugin before activating this plugin
 *
*/
function wpssas_check_require_plugin(){

  // Require parent plugin
  if ( ! is_plugin_active( 's2member/s2member.php' ) and current_user_can( 'activate_plugins' ) ) {
      // Stop activation redirect and show error
      wp_die('Sorry, but this plugin requires S2Membership plguin to be installed and active. <br><a href="' . admin_url( 'plugins.php' ) . '">&laquo; Return to Plugins</a>');
  }
}

/*
 * Add image support to wordpress form
 *
*/
function wpssas_add_edit_form_multipart_encoding() {

    echo ' enctype="multipart/form-data"';

}
add_action('post_edit_form_tag', 'wpssas_add_edit_form_multipart_encoding');

/*
 * Add CSS to wordpress admin area
 *
*/
function wpssas_load_admin_styles() {
  wp_enqueue_style( 'wpssas_admin_css', plugins_url('css/wpssas-admin-css.css',__FILE__ ), false, '' );
}
add_action( 'admin_enqueue_scripts', 'wpssas_load_admin_styles' );

/*
 * Add CSS & js to front-end
 *
*/
function wpssas_load_front_end_css()
{
    wp_enqueue_script( 'wpssas-datatables-js', plugins_url( '/js/datatables-min.js' , __FILE__ ), array( 'jquery' ) );
    wp_enqueue_script( 'wpssas-script', plugins_url( '/js/wpssas-script.js' , __FILE__ ), array( 'jquery' ) );


    wp_register_style( 'wpssas-style', plugins_url( '/css/wpssas-style.css', __FILE__ ), false, '');
    wp_enqueue_style( 'wpssas-style' );

    wp_register_style( 'wpssas-datatables', '//cdn.datatables.net/1.10.11/css/jquery.dataTables.min.css', false, '');
    wp_enqueue_style( 'wpssas-datatables' );



}
add_action( 'wp_enqueue_scripts', 'wpssas_load_front_end_css' );


/*
 * Add Meta boxes to custom post types
 *
*/
function wpssas_metaboxes(){

  add_meta_box( 'wpssas_company_metabox',
                'Company Information',
                'wpssas_display_company_meta_box',
                'wpssas_company', 'normal', 'high'
              );

  add_meta_box( 'wpssas_company_contact_metabox',
                'Company Contact Information',
                'wpssas_display_company_contact_meta_box',
                'wpssas_company_contact', 'normal', 'high'
              );
}

/*
 * Get Current User Company ID
 *
*/
function wpssas_get_company_id(){

  $member_company_args = array( 'author' => get_current_user_id(), 'post_type' => 'wpssas_company');
  $member_company = new WP_Query($member_company_args);
  if(isset($member_company->post->ID) && !is_null($member_company->post->ID))
    return $member_company->post->ID;
  else
    return '';

}
/*
 * Create any post like company, company contact etc.
 *
*/

function wpssas_create_post($post_type, $post_status, $user_id, $post_title){
  $post_information = array(
                            'post_type' 	  =>  $post_type,
                            'post_status'   =>  $post_status,
                            'post_author'   =>  $user_id,
                            'post_title'    =>  wp_strip_all_tags( $post_title )
                            );
  $new_post_id = wp_insert_post( $post_information );
  return $new_post_id;
}

/*
 * Get Current User/company contacts
 *
*/
function wpssas_list_company_contacts($company_id){

  $args = array(
              'post_type'         => 'wpssas_contact',
              'post_status'       => 'publish',
              'posts_per_page'    => -1,
              'orderby'           => 'ASC',
              'meta_query'        => array(
                  array(
                      'key'       => 'user_company',
                      'value'     => $company_id,
                      'compare'   => '='
                  )
              )
              );
  $contacts = get_posts($args);

  $output = '';

  if(!empty($contacts)){
    $contact_page_url = get_permalink(get_option( 'wpssas_company_contacts_page_id' ));

    $output .= '<table id="company-contacts-list" class="display" cellspacing="0" width="100%">';
    $output .= '<thead>';
    $output .= '<tr>';
    $output .= '<th>Contact Name</th>';
    $output .= '<th>Actions</th>';
    $output .= '</tr>';
    $output .= '</thead>';
    $output .= '<tbody>';

  foreach ($contacts as $contact) {

        $output .= '<tr>';
        $output .= '<td>';
        $output .= "$contact->post_title";
        $output .= '</td>';
        $output .= '<td>';

        $contact_id = $contact->ID;


              $output .= '<a href="'.$contact_page_url.'?contact='.$contact_id.'&action=edit" title="Mettre à jour" class="edit wpssas-btn pull-left">  Modify </a>';

              $output .= '<form method="POST" class="wpssas-form contact-delete">';
              $output .= '<input type="hidden" name="contact_id" value="'.$contact_id.'">';
              $output .= '<input type="submit" name="wpssas_delete_company_contact" value="Delete" class="delete">';
              $output .= '</form>';
              $output .= '</td>';
              $output .= '</tr>';

  }
    $output .= '</tbody>';
    $output .= '</table>';
 } else {
          $output .= __("No Contacts Found.", 'wpssas');
      }

      return $output;
}