<?php
function wpssas_display_company_form_fields( $post ){
  // $post is already set, and contains an object: the WordPress post
  if( !is_numeric($post) ){
    global $post;
    $company_id = $post->ID;
  }
  else {
    $company_id = $post;
  }
  $values = get_post_custom( $company_id );
  $company_title    =   isset( $values['nom'] ) ? $values['nom']['0'] : '';
  $adresse_ligne1   =   isset( $values['adresse_ligne1'] ) ? $values['adresse_ligne1']['0'] : '';
  $adresse_ligne2   =   isset( $values['adresse_ligne2'] ) ? $values['adresse_ligne2']['0'] : '';
  $code_postal      =   isset( $values['code_postal'] ) ? $values['code_postal']['0'] : '';
  $ville            =   isset( $values['ville'] ) ? $values['ville']['0'] : '';
  $telephone        =   isset( $values['telephone'] ) ? $values['telephone']['0'] : '';
  $fax              =   isset( $values['fax'] ) ? $values['fax']['0'] : '';
  $email            =   isset( $values['email'] ) ? $values['email']['0'] : '';
  $site_web         =   isset( $values['site_web'] ) ? $values['site_web']['0'] : '';
  $siren            =   isset( $values['siren'] ) ? $values['siren']['0'] : '';
  $siret            =   isset( $values['siret'] ) ? $values['siret']['0'] : '';
  $naf              =   isset( $values['naf'] ) ? $values['naf']['0'] : '';
  $tva_intracom     =   isset( $values['tva_intracom'] ) ? $values['tva_intracom']['0'] : '';
  $iban             =   isset( $values['iban'] ) ? $values['iban']['0'] : '';
  $swift            =   isset( $values['swift'] ) ? $values['swift']['0'] : '';
  $statut_capital   =   isset( $values['statut_capital'] ) ? $values['statut_capital']['0'] : '';
  $company_logo     =   isset( $values['company_logo'] ) ? $values['company_logo']['0'] : '';

    wp_nonce_field( 'wpssas_company_post_type', 'wpssas_company_form' );

  ?>
  <p>
      <label for="company_name"  >Company name</label>
      <input type="text" id="company_name" name="company_name" value="<?php echo $company_title; ?>" maxlength="50"    required="required" class='regular-text'/>
  </p>

  <p>
      <label   for="company_add1">Address</label>
      <input type="text" id="company_add1" name="company_add1" value="<?php echo $adresse_ligne1; ?>" maxlength="50"   required="required" class='regular-text'/>
  </p>

  <p>
      <label   for="company_add2">Address complement</label>
      <input type="text" id="company_add2" name="company_add2" value="<?php echo $adresse_ligne2; ?>" maxlength="50"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_pcode">Zip Code</label>
      <input type="text" id="company_pcode" name="company_pcode" value="<?php echo $code_postal; ?>" maxlength="5"   required="required" class='regular-text'/>
  </p>

  <p>
      <label   for="company_ville">Town</label>
      <input type="text" id="company_ville" name="company_ville" value="<?php echo $ville; ?>" maxlength="50"   required="required" class='regular-text'/>
  </p>

  <p>
      <label   for="company_phone">Telephone</label>
      <input type="text" id="company_phone" name="company_phone" value="<?php echo $telephone; ?>" maxlength="10"   class='regular-text'/>
  </p>

  <p>
      <p class="col-1-1"><label   for="company_fax">Fax</label>
      <input type="text" id="company_fax" name="company_fax" value="<?php echo $fax; ?>" maxlength="10"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_email">Email</label>
      <input type="email" id="company_email" name="company_email" value="<?php echo $email; ?>"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_website">website</label>
      <input type="text" id="company_website" name="company_website" value="<?php echo $site_web; ?>"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_siren">SIREN</label>
      <input type="text" id="company_siren" name="company_siren" value="<?php echo $siren; ?>" maxlength="9"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_siret">SIRET</label>
      <input type="text" id="company_siret" name="company_siret" value="<?php echo $siret; ?>" maxlength="14"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_naf">NAF</label>
      <input type="text" id="company_naf" name="company_naf" value="<?php echo $naf; ?>" maxlength="50"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_tva">TVA Intracom</label>
      <input type="text" id="company_tva" name="company_tva" value="<?php echo $tva_intracom; ?>" maxlength="13"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_iban">IBAN</label>
      <input type="text" id="company_iban" name="company_iban" value="<?php echo $iban; ?>" maxlength="27"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_swift">SWIFT</label>
      <input type="text" id="company_swift" name="company_swift" value="<?php echo $swift; ?>" maxlength="11"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_statut">Other Details</label>
      <input type="text" id="company_statut" name="company_statut" value="<?php echo $statut_capital; ?>" maxlength="50"   class='regular-text'/>
  </p>

  <p>
      <label   for="company_logo">Logo</label>
      <input type="file" id="company_logo" name="company_logo" value=""   />
  </p>
  <?php
    if($company_logo != ''){
      if( $company_logo != '' && is_numeric($company_logo) ){
        $image = wp_get_attachment_image_src ( $company_logo, 'full' ); // get image url from attachment id
          echo "<div class='company-logo'><img src='".$image[0]."' /></div>";
      }
    }
  ?>
  <?php
}

// display metabox in admin area
function wpssas_display_company_meta_box( $post ) {

  wpssas_display_company_form_fields($post);

}

// save custom post type data
add_action( 'save_post', 'wpssas_company_form_fields_process' );
function wpssas_company_form_fields_process( $post_id )
{

    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our nonce isn't there, or we can't verify it, bail
    if( !isset( $_POST['wpssas_company_form'] ) || !wp_verify_nonce( $_POST['wpssas_company_form'], 'wpssas_company_post_type' ) ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_posts' ) ) return;

    if( isset( $_POST['company_name'] ) )
        update_post_meta( $post_id, 'nom', esc_attr( $_POST['company_name'] ) );

    if( isset( $_POST['company_add1'] ) )
      update_post_meta( $post_id, 'adresse_ligne1', esc_attr( $_POST['company_add1'] ) );

    if( isset( $_POST['company_add2'] ) )
      update_post_meta( $post_id, 'adresse_ligne2', esc_attr( $_POST['company_add2'] ) );

    if( isset( $_POST['company_pcode'] ) )
      update_post_meta( $post_id, 'code_postal', esc_attr( $_POST['company_pcode'] ) );

    if( isset( $_POST['company_ville'] ) )
      update_post_meta( $post_id, 'ville', esc_attr( $_POST['company_ville'] ) );

    if( isset( $_POST['company_phone'] ) )
      update_post_meta( $post_id, 'telephone', esc_attr( $_POST['company_phone'] ) );

    if( isset( $_POST['company_fax'] ) )
      update_post_meta( $post_id, 'fax', esc_attr( $_POST['company_fax'] ) );

    if( isset( $_POST['company_email'] ) )
      update_post_meta( $post_id, 'email', esc_attr( $_POST['company_email'] ) );

    if( isset( $_POST['company_website'] ) )
      update_post_meta( $post_id, 'site_web', esc_attr( $_POST['company_website'] ) );

    if( isset( $_POST['company_siren'] ) )
      update_post_meta( $post_id, 'siren', esc_attr( $_POST['company_siren'] ) );

    if( isset( $_POST['company_siret'] ) )
      update_post_meta( $post_id, 'siret', esc_attr( $_POST['company_siret'] ) );

    if( isset( $_POST['company_naf'] ) )
      update_post_meta( $post_id, 'naf', esc_attr( $_POST['company_naf'] ) );

    if( isset( $_POST['company_tva'] ) )
      update_post_meta( $post_id, 'tva_intracom', esc_attr( $_POST['company_tva'] ) );

    if( isset( $_POST['company_iban'] ) )
      update_post_meta( $post_id, 'iban', esc_attr( $_POST['company_iban'] ) );

    if( isset( $_POST['company_swift'] ) )
      update_post_meta( $post_id, 'swift', esc_attr( $_POST['company_swift'] ) );

    if( isset( $_POST['company_statut'] ) )
      update_post_meta( $post_id, 'statut_capital', esc_attr( $_POST['company_statut'] ) );

    if(!empty($_FILES['company_logo']['name'])) {

      $temp = explode(".", $_FILES["company_logo"]["name"]);
      $newfilename = $post_id . '.' . end($temp);


      $upload = wp_upload_bits( $newfilename, null, file_get_contents( $_FILES['company_logo']['tmp_name'] ) );
      $wp_filetype = wp_check_filetype( basename( $upload['file'] ), null );

      $wp_upload_dir = wp_upload_dir();

      $attachment = array(
          'guid' => $wp_upload_dir['baseurl'] . _wp_relative_upload_path( $upload['file'] ),
          'post_mime_type' => $wp_filetype['type'],
          'post_title' => preg_replace('/\.[^.]+$/', '', basename( $upload['file'] )),
          'post_content' => '',
          'post_status' => 'inherit'
      );

      $attach_id = wp_insert_attachment( $attachment, $upload['file'], $post_id );

      require_once(ABSPATH . 'wp-admin/includes/image.php');

      $attach_data = wp_generate_attachment_metadata( $attach_id, $upload['file'] );
      wp_update_attachment_metadata( $attach_id, $attach_data );

      update_post_meta( $post_id, '_thumbnail_id', $attach_id );
      update_post_meta( $post_id, 'company_logo', $attach_id);
    }

}