<?php
function wpssas_display_company_contact_form_fields( $post ){
  $hide_company_drop_down = true;

  if( !is_numeric($post) ){
    global $post;
    $contact_id = $post->ID;
    $hide_company_drop_down = false;
  }
  else {
    $contact_id = $post;
    if( isset($_GET['contact']) && $_GET['contact'] != '' ){
      $contact_id = esc_attr( $_GET['contact'] );
    }

  }
  $values                =   get_post_custom( $contact_id );
  $user_nom              =   isset( $values['user_nom'] ) ? $values['user_nom']['0'] : '';
  $user_prenom           =   isset( $values['user_prenom'] ) ? $values['user_prenom']['0'] : '';
  $user_adresse_ligne1   =   isset( $values['user_adresse_ligne1'] ) ? $values['user_adresse_ligne1']['0'] : '';
  $user_adresse_ligne2   =   isset( $values['user_adresse_ligne2'] ) ? $values['user_adresse_ligne2']['0'] : '';
  $user_code_postal      =   isset( $values['user_code_postal'] ) ? $values['user_code_postal']['0'] : '';
  $user_ville            =   isset( $values['user_ville'] ) ? $values['user_ville']['0'] : '';
  $user_telephone        =   isset( $values['user_telephone'] ) ? $values['user_telephone']['0'] : '';
  $user_fax              =   isset( $values['user_fax'] ) ? $values['user_fax']['0'] : '';
  $user_email            =   isset( $values['user_email'] ) ? $values['user_email']['0'] : '';
  $user_company          =   isset( $values['user_company'] ) ? $values['user_company']['0'] : '';


    wp_nonce_field( 'wpssas_company_contact_post_type', 'wpssas_company_contact_form' );

  ?>
  <p>
      <label for="user_nom" >Last name</label>
      <input type="text" id="user_nom" name="user_nom" value="<?php echo $user_nom; ?>" maxlength="50"   class='regular-text' required="required"/>
  </p>

  <p>
      <label  for="user_prenom">First name</label>
      <input type="text" id="user_prenom" name="user_prenom" value="<?php echo $user_prenom; ?>" maxlength="50"  class='regular-text' />
  </p>

  <p>
      <label  for="user_adresse_ligne1">Address</label>
      <input type="text" id="user_adresse_ligne1" name="user_adresse_ligne1" value="<?php echo $user_adresse_ligne1; ?>" maxlength="50"  class='regular-text' />
  </p>

  <p>
      <label  for="user_adresse_ligne2">Address complement</label>
      <input type="text" id="user_adresse_ligne2" name="user_adresse_ligne2" value="<?php echo $user_adresse_ligne2; ?>" maxlength="50"  class='regular-text' /></p>
  </p>

  <p>
      <label  for="user_code_postal">Zip Code</label>
      <input type="text" id="user_code_postal" name="user_code_postal" value="<?php echo $user_code_postal; ?>" maxlength="50"  class='regular-text' />
  </p>

  <p>
      <label  for="user_ville"> Town </label>
      <input type="text" id="user_ville" name="user_ville" value="<?php echo $user_ville; ?>" maxlength="20"  class='regular-text' />
  </p>

  <p>
      <label  for="user_telephone">Telephone</label>
      <input type="text" id="user_telephone" name="user_telephone" value="<?php echo $user_telephone; ?>" maxlength="10"  class='regular-text' /></p>
  </p>

  <p>
      <label  for="user_fax">Fax</label>
      <input type="text" id="user_fax" name="user_fax" value="<?php echo $user_fax; ?>"  class='regular-text' />
  </p>

  <p>
      <label  for="user_email">Email</label>
      <input type="email" id="user_email" name="user_email" value="<?php echo $user_email; ?>"  class='regular-text' />
  </p>

  <?php if(!$hide_company_drop_down){ ?>
  <p>
      <label  for="user_email">Company</label>
      <select name="user_company" id="user_contact_company" >
          <option selected="selected" disabled="disabled" value=""><?php echo esc_attr( __( 'Select Company' ) ); ?></option>
            <?php

              $companies = get_posts(array('post_type' => 'wpssas_company'));

              foreach ($companies as $company) {
                echo '<option value='. $company->ID .' '. selected( $user_company, $company->ID ) .'>'.$company->post_title.'</option>';
              }
            ?>

        </select>
  </p>
  <?php }
        if($hide_company_drop_down){
          echo '<input type="hidden" name="contact_id" value="'.$contact_id.'" />';
        }
}

// display metabox in admin area
function wpssas_display_company_contact_meta_box( $post ) {

  wpssas_display_company_contact_form_fields($post);

}

// save custom post type data
add_action( 'save_post', 'wpssas_company_contact_form_fields_process' );
function wpssas_company_contact_form_fields_process( $post_id )
{
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our nonce isn't there, or we can't verify it, bail
    if( !isset( $_POST['wpssas_company_contact_form'] ) || !wp_verify_nonce( $_POST['wpssas_company_contact_form'], 'wpssas_company_contact_post_type' ) ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post' ) ) return;

    if( isset( $_POST['user_nom'] ) )
        update_post_meta( $post_id, 'user_nom', esc_attr( $_POST['user_nom'] ) );

    if( isset( $_POST['user_prenom'] ) )
      update_post_meta( $post_id, 'user_prenom', esc_attr( $_POST['user_prenom'] ) );

    if( isset( $_POST['user_adresse_ligne1'] ) )
      update_post_meta( $post_id, 'user_adresse_ligne1', esc_attr( $_POST['user_adresse_ligne1'] ) );

    if( isset( $_POST['user_adresse_ligne2'] ) )
      update_post_meta( $post_id, 'user_adresse_ligne2', esc_attr( $_POST['user_adresse_ligne2'] ) );

    if( isset( $_POST['user_code_postal'] ) )
      update_post_meta( $post_id, 'user_code_postal', esc_attr( $_POST['user_code_postal'] ) );

    if( isset( $_POST['user_ville'] ) )
      update_post_meta( $post_id, 'user_ville', esc_attr( $_POST['user_ville'] ) );

    if( isset( $_POST['user_telephone'] ) )
      update_post_meta( $post_id, 'user_telephone', esc_attr( $_POST['user_telephone'] ) );

    if( isset( $_POST['user_fax'] ) )
      update_post_meta( $post_id, 'user_fax', esc_attr( $_POST['user_fax'] ) );

    if( isset( $_POST['user_email'] ) )
      update_post_meta( $post_id, 'user_email', esc_attr( $_POST['user_email'] ) );

    if( isset( $_POST['user_company'] ) )
      update_post_meta( $post_id, 'user_company', esc_attr( $_POST['user_company'] ) );

    if( !isset( $_POST['user_company'] ) )
      update_post_meta( $post_id, 'user_company', wpssas_get_company_id() );

}