<?php
/**
 * Plugin Name: WP-SASS
 * Plugin URI: #
 * Description: Plugin Description Goes here..
 * Version: 1.0.0
 * Author: fl@ck
 * Author URI: #
 * Text Domain: wpss
 * License: GPL2
 */

if ( !defined( 'ABSPATH' ) ) exit;

require_once( plugin_dir_path( __FILE__ ) . 'inc/wpss-functions.php' );

function wpss_setup() {
  // Register our "company" and "contact" custom post type
  require_once( plugin_dir_path( __FILE__ ) . 'inc/wpss-register-post-type.php' );
}
add_action( 'init', 'wpss_setup' );

function wpss_shortcode() {
  require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/wpss-shortcodes.php' );
  require_once( plugin_dir_path( __FILE__ ) . 'inc/wpss-company-meta-box.php' );
  require_once( plugin_dir_path( __FILE__ ) . 'inc/wpss-company-contact-meta-box.php' );
}
add_action( 'init', 'wpss_shortcode' );


function wpss_create_pages(){

    if('' == get_option( 'wpss_dashboard_page_id' )){

      $dashboard_page = array(
        'post_title'    => 'WPSS Dashboard',
        'post_content'  => '[wpss-dashboard]',
        'post_status'   => 'publish',
        'post_author'   => get_current_user_id(),
        'post_type'     => 'page',
      );
      $wpss_dashboard_page_id = wp_insert_post( $dashboard_page, '' );
      update_option('wpss_dashboard_page_id', $wpss_dashboard_page_id);

    }

    if('' == get_option( 'wpss_company_page_id' )){

      $dashboard_page = array(
        'post_title'    => 'WPSS Company',
        'post_content'  => '[wpss-company]',
        'post_status'   => 'publish',
        'post_author'   => get_current_user_id(),
        'post_type'     => 'page',
      );
      $wpss_company_page_id = wp_insert_post( $dashboard_page, '' );
      update_option('wpss_company_page_id', $wpss_company_page_id);

    }

    if('' == get_option( 'wpss_company_contacts_page_id' )){

      $dashboard_page = array(
        'post_title'    => 'WPSS Company Contact',
        'post_content'  => '[wpss-contact]',
        'post_status'   => 'publish',
        'post_author'   => get_current_user_id(),
        'post_type'     => 'page',
      );
      $wpss_company_contacts_page_id = wp_insert_post( $dashboard_page, '' );
      update_option('wpss_company_contacts_page_id', $wpss_company_contacts_page_id);

    }

}

add_action('admin_menu', 'wpss_plugin_menu');

function wpss_plugin_menu() {
  add_menu_page('WPSS', 'WPSS', 'administrator', 'wpss-settings', 'wpss_settings_page', 'dashicons-admin-generic');
}

function wpss_settings_page() {
?>
<div class="wrap">
<h2>WPSS Settings</h2>

<form method="post" action="options.php">
    <?php settings_fields( 'wpss-settings-group' ); ?>
    <?php do_settings_sections( 'wpss-settings-group' ); ?>
    <table class="form-table">
        <tr valign="top">
        <th scope="row">Dashboard Page</th>
        <td>
          <select name="wpss_dashboard_page_id">
            <option selected="selected" disabled="disabled" value=""><?php echo esc_attr( __( 'Select page' ) ); ?></option>
            <?php
                $selected_page = get_option( 'wpss_dashboard_page_id' );
                $pages = get_pages();
                foreach ( $pages as $page ) {
                    $option = '<option value="' . $page->ID . '" ';
                    $option .= ( $page->ID == $selected_page ) ? 'selected="selected"' : '';
                    $option .= '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                }
            ?>
          </select>
        </td>
        </tr>

        <tr valign="top">
        <th scope="row">Company Page</th>
        <td>
          <select name="wpss_company_page_id">
            <option selected="selected"  disabled="disabled" value=""><?php echo esc_attr( __( 'Select page' ) ); ?></option>
            <?php
                $selected_page = get_option( 'wpss_company_page_id' );
                $pages = get_pages();
                foreach ( $pages as $page ) {
                    $option = '<option value="' . $page->ID . '" ';
                    $option .= ( $page->ID == $selected_page ) ? 'selected="selected"' : '';
                    $option .= '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                }
            ?>
          </select>
        </td>
        </tr>

        <tr valign="top">
        <th scope="row">Company Contact Page</th>
        <td>
          <select name="wpss_company_contacts_page_id">
            <option selected="selected" disabled="disabled" value=""><?php echo esc_attr( __( 'Select page' ) ); ?></option>
            <?php
                $selected_page = get_option( 'wpss_company_contacts_page_id' );
                $pages = get_pages();
                foreach ( $pages as $page ) {
                    $option = '<option value="' . $page->ID . '" ';
                    $option .= ( $page->ID == $selected_page ) ? 'selected="selected"' : '';
                    $option .= '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                }
            ?>
          </select>
        </td>
        </tr>
    </table>

    <?php submit_button(); ?>

</form>
</div>
<?php
}

add_action( 'admin_init', 'wpss_plugin_settings' );
function wpss_plugin_settings() {
	register_setting( 'wpss-settings-group', 'wpss_dashboard_page_id' );
	register_setting( 'wpss-settings-group', 'wpss_company_page_id' );
	register_setting( 'wpss-settings-group', 'wpss_company_contacts_page_id' );

  // add meta boxes for custom post types.
  wpss_metaboxes();
}

function wpss_activation() {

  // Check if require plugins are active.
  wpss_check_require_plugin();

  // Trigger our function that registers the custom post type
  wpss_setup();

  // Create require pages on activation
  wpss_create_pages();

  // Clear the permalinks after the post type has been registered
  flush_rewrite_rules();

}
register_activation_hook( __FILE__, 'wpss_activation' );

function wpss_deactivation() {

  // Our post type will be automatically removed, so no need to unregister it

  // Clear the permalinks to remove our post type's rules
  flush_rewrite_rules();

}

register_deactivation_hook( __FILE__, 'wpss_deactivation' );