<?php
/*
 * Check for S2membership plugin before activating this plugin
 *
*/
function wpss_check_require_plugin(){

  // Require parent plugin
  if ( ! is_plugin_active( 's2member/s2member.php' ) and current_user_can( 'activate_plugins' ) ) {
      // Stop activation redirect and show error
      wp_die('Sorry, but this plugin requires S2Membership plguin to be installed and active. <br><a href="' . admin_url( 'plugins.php' ) . '">&laquo; Return to Plugins</a>');
  }
}

/*
 * Add image support to wordpress form
 *
*/
function wpss_add_edit_form_multipart_encoding() {

    echo ' enctype="multipart/form-data"';

}
add_action('post_edit_form_tag', 'wpss_add_edit_form_multipart_encoding');

/*
 * Add CSS to wordpress admin area
 *
*/
function wpss_load_admin_styles() {
  wp_enqueue_style( 'wpss_admin_css', plugins_url('css/wpss-admin-css.css',__FILE__ ), false, '' );
}
add_action( 'admin_enqueue_scripts', 'wpss_load_admin_styles' );

/*
 * Add CSS & js to front-end
 *
*/
function wpss_load_front_end_css()
{
    wp_enqueue_script( 'wpss-datatables-js', plugins_url( '/js/datatables-min.js' , __FILE__ ), array( 'jquery' ) );
    wp_enqueue_script( 'wpss-script', plugins_url( '/js/wpss-script.js' , __FILE__ ), array( 'jquery' ) );


    wp_register_style( 'wpss-style', plugins_url( '/css/wpss-style.css', __FILE__ ), false, '');
    wp_enqueue_style( 'wpss-style' );

    wp_register_style( 'wpss-datatables', '//cdn.datatables.net/1.10.11/css/jquery.dataTables.min.css', false, '');
    wp_enqueue_style( 'wpss-datatables' );



}
add_action( 'wp_enqueue_scripts', 'wpss_load_front_end_css' );


/*
 * Add Meta boxes to custom post types
 *
*/
function wpss_metaboxes(){

  add_meta_box( 'wpss_company_metabox',
                'Company Information',
                'wpss_display_company_meta_box',
                'wpss_company', 'normal', 'high'
              );

  add_meta_box( 'wpss_company_contact_metabox',
                'Company Contact Information',
                'wpss_display_company_contact_meta_box',
                'wpss_company_contact', 'normal', 'high'
              );
}

/*
 * Get Current User Company ID
 *
*/
function wpss_get_company_id(){

  $member_company_args = array( 'author' => get_current_user_id(), 'post_type' => 'wpss_company');
  $member_company = new WP_Query($member_company_args);
  if(isset($member_company->post->ID) && !is_null($member_company->post->ID))
    return $member_company->post->ID;
  else
    return '';

}
/*
 * Create any post like company, company contact etc.
 *
*/

function wpss_create_post($post_type, $post_status, $user_id, $post_title){
  $post_information = array(
                            'post_type' 	  =>  $post_type,
                            'post_status'   =>  $post_status,
                            'post_author'   =>  $user_id,
                            'post_title'    =>  wp_strip_all_tags( $post_title )
                            );
  $new_post_id = wp_insert_post( $post_information );
  return $new_post_id;
}

/*
 * Get Current User/company contacts
 *
*/
function wpss_list_company_contacts($company_id){

  $args = array(
              'post_type'         => 'wpss_company_contact',
              'post_status'       => 'publish',
              'posts_per_page'    => -1,
              'orderby'           => 'ASC',
              'meta_query'        => array(
                  array(
                      'key'       => 'user_company',
                      'value'     => $company_id,
                      'compare'   => '='
                  )
              )
              );
  $contacts = get_posts($args);

  if(!empty($contacts)){
?>
    <table id="company-contacts-list" class="display" cellspacing="0" width="100%">
      <thead>
          <tr>
              <th>Nom des contacts</th>
              <th>Action</th>
          </tr>
      </thead>
      <tbody>
<?php
  foreach ($contacts as $contact) {
?>
        <tr>
          <td>
              <?php echo $contact->post_title; ?>
          </td>
          <td>
              <?php $contact_id = $contact->ID; ?>

              <a href="?contact=<?php echo $contact_id; ?>&action=edit" title='Mettre à jour' class='edit'>  Edit </a> <!-- Contact Edit link -->

              <form method="POST" class='wpss-form contact-delete'>
                <input type="hidden" name='contact_id' value="<?php echo $contact_id; ?>">
                <input type="submit" name='wpss_delete_company_contact' value='DELETE' class="delete">
              </form>
          </td>
        </tr>

<?php } ?>
      </tbody>
    </table>
<?php } else {
          __e("No Contacts Found.", 'wpss');
      }
}